/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import io.github.fabricators_of_create.porting_lib.loot.LootModifier;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_117;
import net.minecraft.class_131;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import slimeknights.mantle.data.GlobalLootModifierProvider;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.loot.builder.AbstractLootModifierBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.RecipeHelper;

public class ReplaceItemLootModifier
extends LootModifier {
    public static final Codec<ReplaceItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> {
        Codec ingredientCodec = Codec.PASSTHROUGH.flatXmap(dynamic -> {
            JsonElement element = IGlobalLootModifier.getJson((Dynamic)dynamic);
            class_1856 original = element.isJsonPrimitive() ? class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)RecipeHelper.deserializeItem(element.getAsString(), "original", class_1792.class)}) : class_1856.method_52177((JsonElement)element);
            return DataResult.success((Object)original);
        }, ingredient -> DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)ingredient.method_8089())));
        Codec itemOutputCodec = Codec.PASSTHROUGH.flatXmap(dynamic -> DataResult.success((Object)ItemOutput.fromJson(IGlobalLootModifier.getJson((Dynamic)dynamic))), itemOutput -> DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)itemOutput.serialize())));
        return ReplaceItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ingredientCodec.fieldOf("original").forGetter(modifier -> modifier.original)).and((App)itemOutputCodec.fieldOf("replacement").forGetter(modifier -> modifier.replacement)).and((App)MantleLoot.LOOT_ITEM_FUNCTION_CODEC.fieldOf("functions").forGetter(modifier -> modifier.functions)).apply((Applicative)inst, ReplaceItemLootModifier::new);
    });
    private final class_1856 original;
    private final ItemOutput replacement;
    private final class_117[] functions;
    private final BiFunction<class_1799, class_47, class_1799> combinedFunctions;

    protected ReplaceItemLootModifier(class_5341[] conditionsIn, class_1856 original, ItemOutput replacement, class_117[] functions) {
        super(conditionsIn);
        this.original = original;
        this.replacement = replacement;
        this.functions = functions;
        this.combinedFunctions = class_131.method_594((BiFunction[])functions);
    }

    public static Builder builder(class_1856 original, ItemOutput replacement) {
        return new Builder(original, replacement);
    }

    @Nonnull
    protected ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        return new ObjectArrayList((Collection)generatedLoot.stream().map(stack -> {
            if (this.original.method_8093(stack)) {
                class_1799 replacement = this.replacement.get();
                return this.combinedFunctions.apply(ItemHandlerHelper.copyStackWithSize((class_1799)replacement, (int)(replacement.method_7947() * stack.method_7947())), context);
            }
            return stack;
        }).collect(Collectors.toList()));
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final class_1856 input;
        private final ItemOutput replacement;
        private final List<class_117> functions = new ArrayList<class_117>();

        public Builder addFunction(class_117 function) {
            this.functions.add(function);
            return this;
        }

        @Override
        public void build(String name, GlobalLootModifierProvider provider) {
            provider.add(name, MantleLoot.REPLACE_ITEM, new ReplaceItemLootModifier(this.getConditions(), this.input, this.replacement, this.functions.toArray(new class_117[0])));
        }

        private Builder(class_1856 input, ItemOutput replacement) {
            this.input = input;
            this.replacement = replacement;
        }
    }
}

